/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentFilter;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentSuite;
import cz.cuni.amis.pogamut.udk.experiments.impl.AbstractExperimentSuiteRunner;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractSingleThreadExperimentSuiteRunner<RESULT, PARAMETERS>
extends AbstractExperimentSuiteRunner<RESULT, PARAMETERS> {
    public AbstractSingleThreadExperimentSuiteRunner(LogCategory log) {
        super(log);
    }

    protected abstract IExperimentRunResult<RESULT> runSingleExperiment(IExperiment<RESULT, PARAMETERS> var1);

    protected abstract void handleExperimentResult(int var1, IExperiment<RESULT, PARAMETERS> var2, IExperimentRunResult<RESULT> var3);

    @Override
    public void runExperimentSuite(IExperimentSuite<RESULT, PARAMETERS> suite, int startExperiment, int stopAfter, IExperimentFilter<PARAMETERS> filter) {
        this.log.info("Running beforeAllExperiments()");
        suite.beforeAllExperiments();
        int numExperimentsRun = 0;
        List<IExperiment<RESULT, PARAMETERS>> experiments = suite.getExperiments();
        for (int i = startExperiment; i < experiments.size() && (stopAfter <= 0 || numExperimentsRun < stopAfter); ++i) {
            IExperiment<RESULT, PARAMETERS> experiment = experiments.get(i);
            if (filter == null || filter.accept(experiment.getParameters())) {
                suite.beforeExperiment(experiment);
                this.log.info("Running experiment no.: " + i);
                IExperimentRunResult<RESULT> result = this.runSingleExperiment(experiment);
                this.handleExperimentResult(i, experiment, result);
                suite.afterExperiment(experiment);
                Pogamut.getPlatform().close();
                System.gc();
                ++numExperimentsRun;
                continue;
            }
            if (!this.log.isLoggable(Level.FINE)) continue;
            this.log.fine("Experiment no." + i + " was filtered out.");
        }
        this.log.info("All exepriments done, running afterAllExperiments().");
        suite.afterAllExperiments();
    }
}

