/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunner;
import cz.cuni.amis.pogamut.udk.experiments.impl.ExperimentRunResult;
import cz.cuni.amis.pogamut.udk.factory.direct.remoteagent.UDKServerFactory;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractExperimentRunner<RESULT, PARAMETERS>
implements IExperimentRunner<RESULT, PARAMETERS> {
    protected LogCategory log;
    UCCWrapper.UCCWrapperConf uccConfiguration;
    public static long DEFAULT_CLEANUP_TIMEOUT = 3000L;
    protected long timeout;
    protected long serverStartupTimeout;
    protected long cleanupTimeout = DEFAULT_CLEANUP_TIMEOUT;
    protected long udkExeSpawnTimeoutWindows = 10000L;
    protected long udkExeSpawnTimeoutUnix = 30000L;
    protected UDKServerFactory serverFactory;
    protected boolean aggressiveKilling = true;

    public AbstractExperimentRunner(LogCategory log, UCCWrapper.UCCWrapperConf uccConfiguration, long timeout, long serverStartupTimeout) {
        this.log = log;
        this.uccConfiguration = uccConfiguration;
        this.timeout = timeout;
        this.serverStartupTimeout = serverStartupTimeout;
    }

    public void setCleanupTimeout(long cleanupTimeout) {
        this.cleanupTimeout = cleanupTimeout;
    }

    public void setServerStartupTimeout(long serverStartupTimeout) {
        this.serverStartupTimeout = serverStartupTimeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setUdkExeSpawnTimeoutUnix(long udkExeSpawnTimeoutUnix) {
        this.udkExeSpawnTimeoutUnix = udkExeSpawnTimeoutUnix;
    }

    public void setUdkExeSpawnTimeoutWindows(long udkExeSpawnTimeoutWindows) {
        this.udkExeSpawnTimeoutWindows = udkExeSpawnTimeoutWindows;
    }

    public void setAggressiveKilling(boolean aggressiveKilling) {
        this.aggressiveKilling = aggressiveKilling;
    }

    protected UCCWrapper configureAndStartUCCWrapper(UCCWrapper.UCCWrapperConf configuration) {
        UCCWrapper uccWrapper = new UCCWrapper(configuration, this.serverFactory, false);
        uccWrapper.setStartingTimeout(this.serverStartupTimeout);
        uccWrapper.setUdkExeSpawnTimeoutUnix(this.udkExeSpawnTimeoutUnix);
        uccWrapper.setUdkExeSpawnTimeoutWindows(this.udkExeSpawnTimeoutWindows);
        uccWrapper.setAggressiveKilling(this.aggressiveKilling);
        uccWrapper.start();
        return uccWrapper;
    }

    @Override
    public void cleanup() {
        this.serverFactory = null;
    }

    @Override
    public void prepare() {
        this.serverFactory = new UDKServerFactory();
    }

    protected abstract void cleanupServerAfterExperiment();

    protected abstract UCCWrapper getUCCWrapper();

    protected abstract void prepareServerForExperiment(IExperiment<RESULT, PARAMETERS> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExperimentRunResult<RESULT> runExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
        long startTime = System.currentTimeMillis();
        experiment.setLog(this.log);
        String experimentDescription = experiment.getDescription();
        try {
            this.log.info("ExperimentRunner: Running experiment " + experimentDescription);
            this.prepareServerForExperiment(experiment);
            experiment.setServer(this.getUCCWrapper());
            experiment.startExperiment();
            experiment.getFinished().waitFor(this.timeout, (Object[])new Boolean[]{Boolean.TRUE});
            long runningTime = System.currentTimeMillis() - startTime;
            if (!((Boolean)experiment.getFinished().getFlag()).booleanValue()) {
                this.log.info("ExperimentRunner:  Experiment timed out");
                ExperimentRunResult experimentRunResult = ExperimentRunResult.timeout(runningTime, startTime);
                return experimentRunResult;
            }
            if (experiment.isSuccess()) {
                this.log.info("ExperimentRunner:  Experiment success");
                ExperimentRunResult<RESULT> experimentRunResult = ExperimentRunResult.succes(experiment.getResult(), runningTime, startTime);
                return experimentRunResult;
            }
            this.log.info("ExperimentRunner:  Experiment failed");
            ExperimentRunResult experimentRunResult = ExperimentRunResult.failure("Failed.", runningTime, startTime);
            return experimentRunResult;
        }
        catch (Exception ex) {
            long runningTime = System.currentTimeMillis() - startTime;
            this.log.severe("ExperimentRunner:  Experiment exception: " + ex);
            this.log.severe(ExceptionToString.process((Throwable)ex));
            ExperimentRunResult experimentRunResult = ExperimentRunResult.exception(ex, runningTime, startTime);
            return experimentRunResult;
        }
        finally {
            CleanupThread cleanupThread = new CleanupThread(experiment);
            cleanupThread.start();
            try {
                if (!cleanupThread.cleanupLatch.await(this.cleanupTimeout, TimeUnit.MILLISECONDS)) {
                    this.log.severe("ExperimentRunner: Waiting for experiment cleanup timed out.");
                    cleanupThread.interrupt();
                }
            }
            catch (InterruptedException ex) {
                this.log.severe("ExperimentRunner: Waiting for experiment cleanup interrupted.", (Object)ex);
            }
            this.cleanupServerAfterExperiment();
        }
    }

    private class CleanupThread
    extends Thread {
        protected CountDownLatch cleanupLatch;
        IExperiment experiment;

        public CleanupThread(IExperiment experiment) {
            super("ExperimentCleanup");
            this.experiment = experiment;
            this.cleanupLatch = new CountDownLatch(1);
        }

        @Override
        public void run() {
            this.experiment.cleanup();
            this.cleanupLatch.countDown();
        }
    }
}

