/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.flag.Flag;

public abstract class AbstractExperiment<RESULT, PARAMETERS>
implements IExperiment<RESULT, PARAMETERS> {
    private Flag<Boolean> finished = new Flag((Object)false);
    private RESULT result = null;
    private PARAMETERS parameters;
    private boolean succes = false;
    protected LogCategory log;
    protected UCCWrapper ucc;
    protected IUDKServer udkServer;
    protected String mapName;

    public AbstractExperiment(String mapName, PARAMETERS parameters) {
        this.mapName = mapName;
        this.parameters = parameters;
    }

    @Override
    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void cleanup() {
        this.log = null;
        this.ucc = null;
        this.udkServer = null;
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public Flag<Boolean> getFinished() {
        return this.finished;
    }

    @Override
    public final RESULT getResult() {
        return this.result;
    }

    @Override
    public PARAMETERS getParameters() {
        return this.parameters;
    }

    protected void succeed(RESULT result) {
        if (result == null) {
            throw new NullPointerException("Result can't be set to null.");
        }
        this.result = result;
        this.succes = true;
        this.finished.setFlag((Object)true);
    }

    @Override
    public void setServer(UCCWrapper ucc) {
        this.ucc = ucc;
        this.udkServer = ucc.getUTServer();
    }

    public void setUdkServer(IUDKServer udkServer) {
        this.udkServer = udkServer;
    }

    @Override
    public void setLog(LogCategory log) {
        this.log = log;
    }

    @Override
    public void startExperiment() {
    }

    @Override
    public boolean isSuccess() {
        return this.succes;
    }

    protected void fail(String message, Exception e) {
        String messageToLog = message != null ? "Experiment failed." : "Experiment failed: " + message;
        this.log.severe(messageToLog);
        if (e != null) {
            this.log.severe(ExceptionToString.process((Throwable)e));
        }
        this.succes = false;
        this.finished.setFlag((Object)true);
    }

    protected void fail(String message) {
        this.fail(message, null);
    }

    protected void fail(Exception ex) {
        this.fail(null, ex);
    }

    protected void fail() {
        this.fail(null, null);
    }
}

