/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.MultipleAgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.DisconnectObserver;
import cz.cuni.amis.pogamut.udk.experiments.impl.AbstractExperiment;
import cz.cuni.amis.pogamut.udk.experiments.utils.WatchAgent;
import cz.cuni.amis.pogamut.udk.experiments.utils.WatchAgentCallbackAdapter;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotFactory;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotModule;
import cz.cuni.amis.utils.flag.Flag;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class AbstractBotExperiment<RESULT, PARAMETERS>
extends AbstractExperiment<RESULT, PARAMETERS> {
    protected IAgentDescriptor<UDKAgentParameters, UDKBotModule>[] agentDescriptors;
    protected List<UDKBot> runningBots = new ArrayList<UDKBot>();
    protected List<WatchAgent> watchAgents = new ArrayList<WatchAgent>();
    boolean failIfBotStops;

    public AbstractBotExperiment(String mapName, boolean failIfBotStops, PARAMETERS params, IAgentDescriptor<UDKAgentParameters, UDKBotModule> ... bots) {
        super(mapName, params);
        this.agentDescriptors = bots;
        this.failIfBotStops = failIfBotStops;
    }

    public AbstractBotExperiment(String mapName, PARAMETERS params, IAgentDescriptor<UDKAgentParameters, UDKBotModule> ... bots) {
        this(mapName, true, params, bots);
    }

    protected void startBots(IAgentDescriptor<UDKAgentParameters, UDKBotModule>[] bots) {
        AgentRunner runner = new AgentRunner();
        try {
            runner.startAgents(bots);
        }
        catch (Exception ex) {
            this.fail("Bot start failed", ex);
        }
    }

    @Override
    public final void startExperiment() {
        this.beforeBotsStarted();
        this.startBots(this.agentDescriptors);
    }

    protected void beforeBotsStarted() {
    }

    protected void afterBotsStarted() {
    }

    @Override
    public void cleanup() {
        this.failIfBotStops = false;
        for (WatchAgent watch : this.watchAgents) {
            watch.stopWatching();
        }
        for (UDKBot bot : this.runningBots) {
            if (!((IAgentState)bot.getState().getFlag()).isNotState(new Class[]{IAgentStateDown.class})) continue;
            if (((IAgentState)bot.getState().getFlag()).isState(new Class[]{IAgentStateUp.class})) {
                bot.getAct().act((CommandMessage)new DisconnectObserver());
            }
            bot.stop();
        }
        long stopTimeout = 3000L;
        long startStoppingTime = System.currentTimeMillis();
        for (UDKBot bot : this.runningBots) {
            if (!((IAgentState)bot.getState().getFlag()).isNotState(new Class[]{IAgentStateDown.class})) continue;
            long timeSinceStoppingStarted = System.currentTimeMillis() - startStoppingTime;
            if (timeSinceStoppingStarted < stopTimeout) {
                new WaitForAgentStateChange((Flag)bot.getState(), IAgentStateDown.class).await(stopTimeout - timeSinceStoppingStarted, TimeUnit.MILLISECONDS);
            }
            if (!((IAgentState)bot.getState().getFlag()).isNotState(new Class[]{IAgentStateDown.class})) continue;
            this.log.severe("Bot: " + bot.getName() + " did not respond to stop within timeout time. Killing.");
            bot.kill();
        }
        this.runningBots.clear();
        this.watchAgents.clear();
        this.agentDescriptors = null;
        super.cleanup();
    }

    private class AgentRunner
    extends MultipleAgentRunner<UDKBot, UDKAgentParameters, UDKBotModule> {
        private AgentRunner() {
        }

        protected IAgentFactory newAgentFactory(UDKBotModule agentModule) {
            return new UDKBotFactory(agentModule);
        }

        protected IAgentParameters newDefaultAgentParameters() {
            UDKAgentParameters udkParams = new UDKAgentParameters().setAgentId((IAgentId)new AgentId("Agent"));
            if (AbstractBotExperiment.this.ucc != null) {
                udkParams.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(AbstractBotExperiment.this.ucc.getHost(), AbstractBotExperiment.this.ucc.getBotPort()));
            } else {
                udkParams.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress("localhost", 3000));
            }
            return udkParams;
        }

        protected void postStartedHook(List<UDKBot> agents) {
            super.postStartedHook(agents);
            MonitorAgentAliveCallback monitorAliveCallback = new MonitorAgentAliveCallback();
            AbstractBotExperiment.this.runningBots.addAll(agents);
            for (UDKBot bot : agents) {
                WatchAgent watchAgent = new WatchAgent((IAgent)bot, monitorAliveCallback);
                watchAgent.startWatching();
                AbstractBotExperiment.this.watchAgents.add(watchAgent);
            }
            AbstractBotExperiment.this.afterBotsStarted();
        }
    }

    private class MonitorAgentAliveCallback
    extends WatchAgentCallbackAdapter {
        private MonitorAgentAliveCallback() {
        }

        @Override
        public void agentKilled(IAgent agent) {
            AbstractBotExperiment.this.log.info("Bot " + agent.getComponentId().getToken() + " killed");
            if (AbstractBotExperiment.this.failIfBotStops) {
                AbstractBotExperiment.this.fail("Bot " + agent.getComponentId().getToken() + " killed.");
            }
        }

        @Override
        public void agentStopped(IAgent agent) {
            AbstractBotExperiment.this.log.info("Bot " + agent.getComponentId().getToken() + " stopped");
            if (AbstractBotExperiment.this.failIfBotStops) {
                AbstractBotExperiment.this.fail("Bot " + agent.getComponentId().getToken() + " stopped.");
            }
        }
    }
}

