/*
 * Copyright (C) 2012 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.udk.experiments.IExperimentFilter;
import java.util.Arrays;
import java.util.Collection;

/**
 *
 * @author Martin Cerny
 */
public class AndExperimentFilter<PARAMETERS> implements IExperimentFilter<PARAMETERS> {
    Collection<IExperimentFilter<PARAMETERS>> filters;

    public AndExperimentFilter(IExperimentFilter<PARAMETERS> ... filters) {
        this(Arrays.asList(filters));
    }
    
    public AndExperimentFilter(Collection<IExperimentFilter<PARAMETERS>> filters) {
        this.filters = filters;
    }

    @Override
    public boolean accept(PARAMETERS params) {
        for(IExperimentFilter<PARAMETERS> filter : filters){
            if(!filter.accept(params)){
                return false;
            }
        }
        return true;
    }
    
    
}
