/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentFilter;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentSuite;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentSuiteRunner;

/**
 * Helper class for implementing IExperimentSuiteRunner interface
 * @author Martin Cerny
 */
public abstract class AbstractExperimentSuiteRunner<RESULT, PARAMETERS> implements IExperimentSuiteRunner<RESULT, PARAMETERS> {

    protected LogCategory log;

    public AbstractExperimentSuiteRunner(LogCategory log) {
        this.log = log;
    }

    
    
    @Override
    public final void runExperimentSuite(IExperimentSuite<RESULT, PARAMETERS> suite) {
        runExperimentSuite(suite, 0);
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<RESULT, PARAMETERS> suite, int startExperiment) {
        runExperimentSuite(suite, startExperiment, null);
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<RESULT, PARAMETERS> suite, IExperimentFilter<PARAMETERS> filter) {
        runExperimentSuite(suite, 0, filter);
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<RESULT, PARAMETERS> suite, int startExperiment, int stopAfter) {
        runExperimentSuite(suite, startExperiment, stopAfter, null);
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<RESULT, PARAMETERS> suite, int startExperiment, IExperimentFilter<PARAMETERS> filter) {
        runExperimentSuite(suite, startExperiment, 0, filter);
    }
    
    
    
    
    
}
