/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments;

import java.io.IOException;

/**
 * Interface for classes that handle results of experiments
 * @author Martin Cerny
 */
public interface IResultWriter<RESULT, EXPERIMENT_PARAMS> {
    
    public void init() throws IOException;
    
    /**
     * Writes result of an experiment with specified params.
     * @param experimentParams
     * @param result experiment result 
     * @throws IOException 
     */
    public void writeResult(int experimentNumber, IExperimentRunResult<RESULT> result, EXPERIMENT_PARAMS experimentParams) throws IOException;
    
    public void close() throws IOException;
}
