/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.udk.experiments.ITimeConsumedMeasuring;
import java.util.HashMap;
import java.util.Map;

public class TimeConsumedMeasuring<IDENTIFIER>
implements ITimeConsumedMeasuring<IDENTIFIER> {
    Map<IDENTIFIER, Integer> taskRecursionDepth = new HashMap<IDENTIFIER, Integer>();
    Map<IDENTIFIER, Long> taskStartTime = new HashMap<IDENTIFIER, Long>();
    Map<IDENTIFIER, Long> taskConsumedTime = new HashMap<IDENTIFIER, Long>();

    protected void addConsumedTime(IDENTIFIER identifier, long milis) {
        Long previousTime = this.taskConsumedTime.get(identifier);
        if (previousTime == null) {
            previousTime = 0L;
        }
        this.taskConsumedTime.put(identifier, previousTime + milis);
    }

    @Override
    public synchronized void taskConsumedTime(IDENTIFIER identifier, long milis) {
        this.addConsumedTime(identifier, milis);
    }

    @Override
    public synchronized void taskFinished(IDENTIFIER identifier) {
        Integer recursionDepth = this.taskRecursionDepth.get(identifier);
        if (recursionDepth == null || recursionDepth <= 0) {
            throw new IllegalStateException("Cannot finish a task that has not started. Task:" + identifier);
        }
        int newRecursionDepth = recursionDepth - 1;
        if (newRecursionDepth == 0) {
            long timeSpent = System.currentTimeMillis() - this.taskStartTime.get(identifier);
            this.addConsumedTime(identifier, timeSpent);
        }
        this.taskRecursionDepth.put(identifier, newRecursionDepth);
    }

    @Override
    public synchronized void taskStarted(IDENTIFIER identifier) {
        Integer recursionDepth = this.taskRecursionDepth.get(identifier);
        if (recursionDepth == null || recursionDepth <= 0) {
            recursionDepth = 0;
            this.taskStartTime.put(identifier, System.currentTimeMillis());
        }
        this.taskRecursionDepth.put(identifier, recursionDepth + 1);
    }

    @Override
    public long getConsumedTime(IDENTIFIER identifier) {
        Long time = this.taskConsumedTime.get(identifier);
        if (time == null) {
            return 0L;
        }
        return time;
    }

    @Override
    public synchronized void finishAllTasks() {
        long finishTime = System.currentTimeMillis();
        for (Map.Entry<IDENTIFIER, Integer> recDepth : this.taskRecursionDepth.entrySet()) {
            if (recDepth.getValue() <= 0) continue;
            recDepth.setValue(0);
            long timeSpent = finishTime - this.taskStartTime.get(recDepth.getKey());
            this.addConsumedTime(recDepth.getKey(), timeSpent);
        }
    }
}

