/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentFilter;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunner;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentSuite;
import cz.cuni.amis.pogamut.udk.experiments.IResultWriter;
import cz.cuni.amis.pogamut.udk.experiments.impl.AbstractSingleThreadExperimentSuiteRunner;
import cz.cuni.amis.pogamut.udk.experiments.impl.FreshServerExperimentRunner;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import java.io.IOException;

public class SimpleExperimentSuiteRunner<RESULT, PARAMETERS>
extends AbstractSingleThreadExperimentSuiteRunner<RESULT, PARAMETERS> {
    private IExperimentRunner<RESULT, PARAMETERS> runner;
    private IResultWriter<RESULT, PARAMETERS> resultWriter;

    public SimpleExperimentSuiteRunner(LogCategory log, long singleExperimentTimeout) {
        this(new FreshServerExperimentRunner(log, singleExperimentTimeout, new UCCWrapper.UCCWrapperConf()), log);
    }

    public SimpleExperimentSuiteRunner(IExperimentRunner<RESULT, PARAMETERS> runner, LogCategory log) {
        this(runner, null, log);
    }

    public SimpleExperimentSuiteRunner(IResultWriter<RESULT, PARAMETERS> resultWriter, LogCategory log, long singleExperimentTimeout) {
        this(resultWriter, log, singleExperimentTimeout, new UCCWrapper.UCCWrapperConf());
    }

    public SimpleExperimentSuiteRunner(IResultWriter<RESULT, PARAMETERS> resultWriter, LogCategory log, long singleExperimentTimeout, UCCWrapper.UCCWrapperConf wrapperConf) {
        this(new FreshServerExperimentRunner(log, singleExperimentTimeout, wrapperConf), resultWriter, log);
    }

    public SimpleExperimentSuiteRunner(IExperimentRunner<RESULT, PARAMETERS> runner, IResultWriter<RESULT, PARAMETERS> resultWriter, LogCategory log) {
        super(log);
        this.runner = runner;
        this.resultWriter = resultWriter;
    }

    @Override
    protected void handleExperimentResult(int experimentNumber, IExperiment<RESULT, PARAMETERS> experiment, IExperimentRunResult<RESULT> result) {
        if (this.resultWriter == null) {
            return;
        }
        try {
            this.resultWriter.writeResult(experimentNumber, result, experiment.getParameters());
        }
        catch (IOException ex) {
            this.log.severe("Could not write experiment result", (Object)ex);
        }
    }

    @Override
    protected IExperimentRunResult<RESULT> runSingleExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
        return this.runner.runExperiment(experiment);
    }

    @Override
    public void runExperimentSuite(IExperimentSuite<RESULT, PARAMETERS> suite, int startExperiment, int stopAfter, IExperimentFilter<PARAMETERS> filter) {
        if (this.resultWriter != null) {
            try {
                this.resultWriter.init();
            }
            catch (IOException ex) {
                this.log.severe("Error initializing result writer", (Object)ex);
                return;
            }
        }
        this.runner.prepare();
        super.runExperimentSuite(suite, startExperiment, stopAfter, filter);
        this.runner.cleanup();
        if (this.resultWriter != null) {
            try {
                this.resultWriter.close();
            }
            catch (IOException ex) {
                this.log.severe("Error closing result writer", (Object)ex);
                return;
            }
        }
    }
}

