/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunner;
import cz.cuni.amis.pogamut.udk.experiments.impl.ExperimentRunResult;
import cz.cuni.amis.pogamut.udk.factory.direct.remoteagent.UDKServerFactory;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;

public abstract class AbstractExperimentRunner<RESULT, PARAMETERS>
implements IExperimentRunner<RESULT, PARAMETERS> {
    protected LogCategory log;
    UCCWrapper.UCCWrapperConf uccConfiguration;
    protected long timeout;
    protected long serverStartupTimeout;
    protected UDKServerFactory serverFactory;

    public AbstractExperimentRunner(LogCategory log, UCCWrapper.UCCWrapperConf uccConfiguration, long timeout, long serverStartupTimeout) {
        this.log = log;
        this.uccConfiguration = uccConfiguration;
        this.timeout = timeout;
        this.serverStartupTimeout = serverStartupTimeout;
    }

    @Override
    public void cleanup() {
        this.serverFactory = null;
    }

    @Override
    public void prepare() {
        this.serverFactory = new UDKServerFactory();
    }

    protected abstract void cleanupServerAfterExperiment();

    protected abstract UCCWrapper getUCCWrapper();

    protected abstract void prepareServerForExperiment(IExperiment<RESULT, PARAMETERS> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExperimentRunResult<RESULT> runExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
        long startTime = System.currentTimeMillis();
        experiment.setLog(this.log);
        String experimentDescription = experiment.getDescription();
        try {
            this.log.info("ExperimentRunner: Running experiment " + experimentDescription);
            this.prepareServerForExperiment(experiment);
            experiment.setServer(this.getUCCWrapper());
            experiment.startExperiment();
            experiment.getFinished().waitFor(this.timeout, (Object[])new Boolean[]{Boolean.TRUE});
            long runningTime = System.currentTimeMillis() - startTime;
            if (!((Boolean)experiment.getFinished().getFlag()).booleanValue()) {
                this.log.info("ExperimentRunner:  Experiment timed out");
                ExperimentRunResult experimentRunResult = ExperimentRunResult.timeout(runningTime, startTime);
                return experimentRunResult;
            }
            if (experiment.isSuccess()) {
                this.log.info("ExperimentRunner:  Experiment success");
                ExperimentRunResult<RESULT> experimentRunResult = ExperimentRunResult.succes(experiment.getResult(), runningTime, startTime);
                return experimentRunResult;
            }
            this.log.info("ExperimentRunner:  Experiment failed");
            ExperimentRunResult experimentRunResult = ExperimentRunResult.failure("Failed.", runningTime, startTime);
            return experimentRunResult;
        }
        catch (Exception ex) {
            long runningTime = System.currentTimeMillis() - startTime;
            this.log.severe("ExperimentRunner:  Experiment exception: " + ex);
            this.log.severe(ExceptionToString.process((Throwable)ex));
            ExperimentRunResult experimentRunResult = ExperimentRunResult.exception(ex, runningTime, startTime);
            return experimentRunResult;
        }
        finally {
            experiment.cleanup();
            this.cleanupServerAfterExperiment();
        }
    }
}

