/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunner;
import cz.cuni.amis.pogamut.udk.factory.direct.remoteagent.UDKServerFactory;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper.UCCWrapperConf;
import cz.cuni.amis.utils.ExceptionToString;

/**
 * A simple experiment runner that starts up a fresh UDK server for each experiment.
 * Sets up UDK server, runs the experiment and tries to terminate the server afterwards.
 * @author Martin Cerny
 */
public class FreshServerExperimentRunner<RESULT, PARAMETERS> extends AbstractExperimentRunner<RESULT, PARAMETERS> {

    private UCCWrapper currentUCCWrapper;

    public FreshServerExperimentRunner(LogCategory log, long timeout, UCCWrapperConf configuration) {
        this(log, timeout, configuration, UCCWrapper.DEFAULT_START_TIMEOUT);
    }

    public FreshServerExperimentRunner(LogCategory log, long timeout, UCCWrapperConf configuration, long serverStartupTimeout) {
        super(log, configuration, timeout, serverStartupTimeout);
    }


    
    
    @Override
    protected UCCWrapper getUCCWrapper() {
        return currentUCCWrapper;
    }

    @Override
    protected void prepareServerForExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
        log.info("ExperimentRunner: Starting server.");
        currentUCCWrapper = null;
        UCCWrapperConf experimentConfiguration = new UCCWrapperConf();
        experimentConfiguration.applyDefaults(uccConfiguration);
        experimentConfiguration.setMapName(experiment.getMapName());
        currentUCCWrapper = new UCCWrapper(experimentConfiguration, serverStartupTimeout, serverFactory);


        log.info("ExperimentRunner: Waiting for 5 sec to give UDKServer some time to catch up...");

        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }

//		log.info("FreshServerExperimentRunner: Checking required map " + requiredMap);
//		
//		if (server.getMapName().equals(requiredMap)) {
//			log.info("FreshServerExperimentRunner: Map ok!");
//		} else {
//			fail("FreshServerExperimentRunner: GBUDK is running wrong map " + server.getMapName() + ", required map is " + requiredMap); 
//		}
//		

        log.info("ExperimentRunner: Server started.");
    }

    @Override
    protected void cleanupServerAfterExperiment() {
        if (currentUCCWrapper != null) {
            try {
                currentUCCWrapper.stop();
            } catch (Exception ex) {
                log.severe("Failed to stop UCC.");
                log.severe(ExceptionToString.process(ex));
            }
        }
    }
}
