/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.release;

import cz.cuni.amis.pogamut.release.PogamutReleaseConfig;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.simple_logging.SimpleLogging;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PogamutRelease
implements Runnable {
    private PogamutReleaseConfig config;
    private Logger log;

    public PogamutRelease() {
        this.config = new PogamutReleaseConfig();
    }

    public PogamutRelease(PogamutReleaseConfig config) {
        NullCheck.check((Object)config, (String)"config");
        this.config = config;
    }

    public PogamutRelease(File xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("'xmlFile' can't be null!");
        }
        this.config = PogamutReleaseConfig.loadXML(xmlFile);
    }

    public PogamutReleaseConfig getConfig() {
        return this.config;
    }

    public void setConfig(PogamutReleaseConfig config) {
        this.config = config;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[DOLOOP]], but top level block is 22[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void logInfo(String msg) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(msg);
        }
    }

    protected void logWarning(String msg) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(msg);
        }
    }

    protected void logSevere(String msg) {
        if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
            this.log.severe(msg);
        }
    }

    public static String formatTime(double millis) {
        double origMillis = millis;
        boolean time = false;
        StringBuffer sb = new StringBuffer();
        if (millis > 3600000.0) {
            int hours = (int)Math.floor(millis / 3600000.0);
            millis -= (double)(hours * 60 * 60 * 1000);
            sb.append(hours);
            sb.append("h ");
            time = true;
        }
        if (time || millis > 60000.0) {
            int mins = (int)Math.floor(millis / 60000.0);
            millis -= (double)(mins * 60 * 1000);
            String strMins = String.valueOf(mins);
            while (strMins.length() < 2) {
                strMins = "0" + strMins;
            }
            sb.append(mins);
            sb.append("m ");
            time = true;
        }
        int secs = (int)Math.floor(millis / 1000.0);
        int ms = (int)Math.floor(millis -= (double)(secs * 1000));
        millis -= (double)ms;
        String strSecs = String.valueOf(secs);
        while (strSecs.length() < 2) {
            strSecs = "0" + strSecs;
        }
        String strMs = String.valueOf(ms);
        while (strMs.length() < 3) {
            strMs = "0" + strMs;
        }
        sb.append(strSecs);
        sb.append(".");
        sb.append(strMs);
        sb.append("s");
        return sb.toString();
    }

    public static void main(String[] args) {
        PogamutRelease release;
        String definition = "PogamutRelease.xml";
        if (args.length > 0 && (definition = args[0]) == null) {
            definition = "PogamutRelease.xml";
        }
        SimpleLogging.initLogging();
        SimpleLogging.addFileLogging((String)"PogamutRelease.log");
        Logger log = Logger.getAnonymousLogger();
        log.info("---[[ POGAMUT RELEASE ]]---");
        log.info("Loading definition from xml file: " + definition + " --> " + new File(definition).getAbsoluteFile());
        File file = new File(definition);
        if (!file.exists() || !file.isFile()) {
            log.severe("FAILED! Definition file not found at: " + file.getAbsolutePath());
            log.severe("Usage: java -jar PogamutRelease.jar [path-to-definition-xml-file]");
            log.info("---[[ END ]]---");
            System.exit(1);
            return;
        }
        try {
            release = new PogamutRelease(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Usage: java -jar PogamutRelease.jar [path-to-definition-xml-file]");
            log.info("---[[ END ]]---");
            return;
        }
        release.setLog(log);
        log.info("Definition file loaded.");
        release.run();
        log.info("---[[ END ]]---");
    }
}

