package cz.cuni.amis.pogamut.release;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.io.xml.DomDriver;

import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import cz.cuni.amis.utils.rewrite.IncludeDir;
import cz.cuni.amis.utils.rewrite.RewriteFilesConfig;

@XStreamAlias(value="PogamutReleaseConfig")
public class PogamutReleaseConfig {
	
	@XStreamAlias(value="baseDir")
	@XStreamAsAttribute
	private File baseDir;
	
	@XStreamImplicit
	private List<PogamutReleaseStep> steps;
	
	public static PogamutReleaseConfig loadXML(File xmlFile) {
		if (xmlFile == null) {
			throw new IllegalArgumentException("'xmlFile' can't be null!");
		}
		FileReader reader;
		try {
			reader = new FileReader(xmlFile);
		} catch (FileNotFoundException e1) {
			throw new RuntimeException("File " + xmlFile.getAbsolutePath() + " not found: " + e1.getMessage(), e1);
		}
		XStream xstream = new XStream(new DomDriver());
		xstream.autodetectAnnotations(true);
		xstream.alias(PogamutReleaseConfig.class.getAnnotation(XStreamAlias.class).value(), PogamutReleaseConfig.class);
		Object obj = xstream.fromXML(reader);
		try {
			reader.close();
		} catch (IOException e) {
		}
		if (obj == null || !(obj instanceof PogamutReleaseConfig)) {
			throw new RuntimeException("file " + xmlFile.getAbsolutePath() + " doesn't contain a xml with PogamutReleaseConfig");
		}
		return (PogamutReleaseConfig)obj;
	}
	
	private PogamutReleaseConfig readResolve() {
		if (baseDir == null) baseDir = new File(".");
		if (steps == null) steps = new ArrayList<PogamutReleaseStep>();
		for (PogamutReleaseStep step : steps) {
			if (step.getRewriteFiles() != null) {
				for (RewriteFilesConfig config : step.getRewriteFiles()) {
					if (config.getGlobals().getDir() != null) {
						if (!config.getGlobals().getDir().isAbsolute()) {						
							config.getGlobals().setDir(new File(baseDir, config.getGlobals().getDir().getPath()));
						}
					}
					for (IncludeDir inc : config.getDirs()) {
						if (inc.getDir() != null) {
							if (!inc.getDir().isAbsolute()) {
								inc.setDir(new File(baseDir, inc.getDir().getPath()));
							}
						}
					}
				}
			}
			if (step.getProcessExecution() != null) {
				for (ProcessExecutionConfig config : step.getProcessExecution()) {
					if (!new File(config.getExecutionDir()).isAbsolute()) {
						config.setExecutionDir(new File(baseDir, config.getExecutionDir()).getAbsolutePath());
					}
				}
			}
		}
		return this;
	}

	public List<PogamutReleaseStep> getSteps() {
		return steps;
	}

	public void setSteps(List<PogamutReleaseStep> steps) {
		this.steps = steps;
	}
	
}
