/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.release;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.cuni.amis.pogamut.release.PogamutReleaseStep;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import cz.cuni.amis.utils.rewrite.IncludeDir;
import cz.cuni.amis.utils.rewrite.RewriteFilesConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="PogamutReleaseConfig")
public class PogamutReleaseConfig {
    @XStreamAlias(value="baseDir")
    @XStreamAsAttribute
    private File baseDir;
    @XStreamImplicit
    private List<PogamutReleaseStep> steps;

    public static PogamutReleaseConfig loadXML(File xmlFile) {
        FileReader reader;
        if (xmlFile == null) {
            throw new IllegalArgumentException("'xmlFile' can't be null!");
        }
        try {
            reader = new FileReader(xmlFile);
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException("File " + xmlFile.getAbsolutePath() + " not found: " + e1.getMessage(), e1);
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.autodetectAnnotations(true);
        xstream.alias(PogamutReleaseConfig.class.getAnnotation(XStreamAlias.class).value(), PogamutReleaseConfig.class);
        Object obj = xstream.fromXML((Reader)reader);
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (obj == null || !(obj instanceof PogamutReleaseConfig)) {
            throw new RuntimeException("file " + xmlFile.getAbsolutePath() + " doesn't contain a xml with PogamutReleaseConfig");
        }
        return (PogamutReleaseConfig)obj;
    }

    private PogamutReleaseConfig readResolve() {
        if (this.baseDir == null) {
            this.baseDir = new File(".");
        }
        if (this.steps == null) {
            this.steps = new ArrayList<PogamutReleaseStep>();
        }
        for (PogamutReleaseStep step : this.steps) {
            if (step.getRewriteFiles() != null) {
                for (RewriteFilesConfig rewriteFilesConfig : step.getRewriteFiles()) {
                    if (!rewriteFilesConfig.getGlobals().getDir().isAbsolute()) {
                        rewriteFilesConfig.getGlobals().setDir(new File(this.baseDir, rewriteFilesConfig.getGlobals().getDir().getPath()));
                    }
                    for (IncludeDir inc : rewriteFilesConfig.getDirs()) {
                        if (inc.getDir().isAbsolute()) continue;
                        inc.setDir(new File(this.baseDir, inc.getDir().getPath()));
                    }
                }
            }
            if (step.getProcessExecution() == null) continue;
            for (ProcessExecutionConfig processExecutionConfig : step.getProcessExecution()) {
                if (new File(processExecutionConfig.getExecutionDir()).isAbsolute()) continue;
                processExecutionConfig.setExecutionDir(new File(this.baseDir, processExecutionConfig.getExecutionDir()).getAbsolutePath());
            }
        }
        return this;
    }

    public List<PogamutReleaseStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<PogamutReleaseStep> steps) {
        this.steps = steps;
    }
}

