/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.ut2004.project.template;

import cz.cuni.amis.nb.pogamut.base.project.template.utils.ProjectCreationUtils;
import cz.cuni.amis.nb.pogamut.base.project.template.utils.TemplateBotProjectWizardPanel;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PogamutGroovyBotWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;

    public static PogamutGroovyBotWizardIterator createIterator() {
        return new PogamutGroovyBotWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new TemplateBotProjectWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(PogamutGroovyBotWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set instantiate() throws IOException {
        ProjectCreationUtils.handleWizardDescriptor((WizardDescriptor)this.wiz);
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        dirF.mkdirs();
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        ProjectCreationUtils.unZipFile((InputStream)template.getInputStream(), (FileObject)dir);
        String projName = (String)this.wiz.getProperty("name");
        File sourceDir = new File(dirF, "src/groovybottemplate/");
        for (File file : sourceDir.listFiles()) {
            if (!file.isFile()) continue;
            ProjectCreationUtils.substituteInFile((File)file, (Pattern)Pattern.compile("groovybottemplate"), (String)projName.toLowerCase());
            ProjectCreationUtils.substituteInFile((File)file, (Pattern)Pattern.compile("__PROJECT_NAME__"), (String)projName);
            if (!file.getName().equals("Main.groovy")) continue;
            ProjectCreationUtils.substituteInFile((File)file, (Pattern)Pattern.compile("Main"), (String)projName);
            file.renameTo(new File(file.getParentFile().getAbsolutePath() + File.separator + projName + ".groovy"));
        }
        ProjectCreationUtils.substituteInFile((File)new File(dirF, "nbproject/project.properties"), (Pattern)Pattern.compile("groovybottemplate"), (String)projName.toLowerCase());
        ProjectCreationUtils.substituteInFile((File)new File(dirF, "nbproject/project.properties"), (Pattern)Pattern.compile("GroovyBotTemplate"), (String)projName);
        ProjectCreationUtils.substituteInFile((File)new File(dirF, "nbproject/project.properties"), (Pattern)Pattern.compile("Main"), (String)projName);
        File rootPackage = new File(dirF, "src/groovybottemplate");
        rootPackage.renameTo(new File(dirF, "src/" + projName.toLowerCase()));
        ProjectCreationUtils.substituteInFile((File)new File(dirF, "nbproject/project.xml"), (Pattern)Pattern.compile("<name>GroovyBotTemplate</name>"), (String)("<name>" + projName + "</name>"));
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

