/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.api.pogamut.unreal.server;

import cz.cuni.amis.nb.api.pogamut.base.server.ReconnectingServerDefinition;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.server.IWorldServer;
import cz.cuni.amis.pogamut.unreal.communication.messages.gbcommands.ChangeMap;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.IOException;
import java.net.URI;

public abstract class UnrealServerDefinition<T extends IUnrealServer>
extends ReconnectingServerDefinition<T> {
    long mapChangeTimeout = 0L;
    static final long MAP_CHANGE_TIMEOUT = 60000L;
    transient ICommandListener<ChangeMap> mapChangeListener = null;
    protected transient T server = null;

    protected void tryToStartServer() throws PogamutException {
        if (this.server != null && !((IAgentState)this.server.getState().getFlag()).isState(new Class[]{IAgentStateStopped.class, IAgentStateFailed.class})) {
            this.server.stop();
        }
        this.server = this.createServer();
        this.setNewServer((IWorldServer)this.server);
    }

    protected abstract T createServer();

    protected void serverStopped(T server) {
        super.serverStopped(server);
        server.getAct().removeCommandListener(ChangeMap.class, this.mapChangeListener);
    }

    public void spectate() throws PogamutException {
        URI uri = (URI)this.getUriFlag().getFlag();
        if (uri == null) {
            throw new PogamutException("Could not start viewer because the server URI isn't set.", (Object)this);
        }
        try {
            this.startSpectImpl(uri);
        }
        catch (IOException ex) {
            throw new PogamutException("Viewer start failed.", (Throwable)ex);
        }
    }

    protected abstract void startSpectImpl(URI var1) throws IOException;
}

