/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntityUpdater;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLFolder;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLLocation;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLProperty;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLRotation;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLVelocity;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.unreal.bot.IUnrealBot;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class TLAgentEntity
extends TLEntity {
    private String agentName;
    private transient IAgent agent;
    protected TLLocation botLocation;
    protected TLRotation botRotation;
    protected TLVelocity botVelocity;
    protected transient TLEntityUpdater updateWorker;

    public TLAgentEntity(TLDatabase db, IUnrealBot agent) {
        super(db, Calendar.getInstance().getTimeInMillis());
        Logger.getLogger("TL").info("New TLAgentEntity " + agent.getName());
        this.agent = agent;
        this.agentName = this.getAgent().getName();
        this.botLocation = new TLLocation(agent);
        this.botRotation = new TLRotation(agent);
        this.botVelocity = new TLVelocity(agent);
        Map categories = agent.getLogger().getCategories();
        Object[] names = categories.keySet().toArray(new String[0]);
        Arrays.sort(names);
        for (Object categoryName : names) {
            this.addLogRecording((Logger)categories.get(categoryName));
        }
        this.storageFolder = new TLFolder(agent.getIntrospection().getName());
        this.updateWorker = new TLEntityUpdater(this, agent);
        this.updateWorker.execute();
    }

    public IAgent getAgent() {
        return this.agent;
    }

    @Override
    public String getDisplayName() {
        return this.agentName;
    }

    @Override
    public Location getLocation(long time) {
        Location location = (Location)this.botLocation.getValue(time);
        return location == null ? null : new Location(location);
    }

    @Override
    public Rotation getRotation(long time) {
        return new Rotation((Rotation)this.botRotation.getValue(time));
    }

    @Override
    public Velocity getVelocity(long time) {
        return new Velocity((Velocity)this.botVelocity.getValue(time));
    }

    @Override
    public void finish() {
        this.updateWorker.cancel(false);
        super.finish();
    }

    public void printFolders(PrintStream stream) {
        try {
            this.printFolders(this.agent.getIntrospection(), stream);
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void printTimelinedata() throws IntrospectionException {
        Folder root = this.getAgent().getIntrospection();
        Folder tl = root.getFolder("timelineData");
        if (tl == null) {
            System.out.println("Not timelinedata folder");
        }
        System.out.println("List properties " + tl.getProperties().length);
        for (Property prop : tl.getProperties()) {
            System.out.println(prop.getName() + " " + prop.getType() + " " + prop.getValue());
        }
    }

    private void printFolders(Folder folder, PrintStream stream) throws IntrospectionException {
        stream.println("Folder " + folder.getName());
        for (Property property : folder.getProperties()) {
            stream.println("Property " + property.getName() + " type " + property.getType());
        }
        for (Property property : folder.getFolders()) {
            stream.println("Subfolder " + property.getName());
            this.printFolders((Folder)property, stream);
        }
        stream.println("Folder " + folder.getName() + " end");
    }

    private void printTLFolders(TLFolder folder) {
        System.out.println("TLFolder " + folder.getName());
        for (TLProperty prop : folder.getProperties()) {
            System.out.println("TLProperty " + prop.getName() + " type " + prop.getType());
        }
        for (TLFolder subfolder : folder.getSubfolders()) {
            System.out.println("TLSubfolder " + subfolder.getName());
            this.printTLFolders(subfolder);
        }
        System.out.println("TLFolder " + folder.getName() + " end");
    }

    private void printVariables(TLFolder folder) {
        System.out.println("Write info from variables of folder " + folder.getName());
        for (TLProperty property : folder.getProperties()) {
            property.printDebug();
        }
        for (TLFolder subfolder : folder.getSubfolders()) {
            System.out.println("List subfolder " + subfolder.getName());
            this.printVariables(subfolder);
        }
        System.out.println("EOL for folder " + folder.getName());
    }
}

