/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.agent;

import cz.cuni.amis.nb.pogamut.base.NamedAction;
import cz.cuni.amis.nb.pogamut.base.agent.Agent3DNode;
import cz.cuni.amis.nb.pogamut.unreal.services.IPogamutEnvironments;
import cz.cuni.amis.pogamut.unreal.bot.IUnrealBot;
import cz.cuni.amis.pogamut.unreal.bot.impl.NativeUnrealBotAdapter;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.exception.PogamutException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class UnrealAgentNode<T extends IUnrealBot>
extends Agent3DNode<T>
implements LookupListener {
    private boolean selectedFlag = false;
    private IUnrealMap map;
    private Lookup.Template selectedTemplate;
    private Lookup.Result<NativeUnrealBotAdapter> selectedResult;

    public UnrealAgentNode(T agent, IUnrealServer server) {
        super(agent);
        IPogamutEnvironments environments = (IPogamutEnvironments)Lookup.getDefault().lookup(IPogamutEnvironments.class);
        if (environments == null) {
            return;
        }
        this.map = server.getMap();
        this.selectedTemplate = new Lookup.Template(IUnrealBot.class);
        this.selectedResult = environments.getEnvironmentSelection(this.map).lookup(this.selectedTemplate);
        this.selectedResult.addLookupListener((LookupListener)this);
    }

    public Action[] getActions(boolean context) {
        Action[] oldActs = super.getActions(context);
        Action[] acts = Arrays.copyOf(oldActs, oldActs.length + 2);
        acts[oldActs.length + 1] = new NamedAction("ACT_Respawn", UnrealAgentNode.class){

            protected void action(ActionEvent e) throws PogamutException {
                ((IUnrealBot)UnrealAgentNode.this.agent).respawn();
            }
        };
        return acts;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = new Sheet.Set();
        props.setDisplayName("Agent configuration");
        props.setName("AgentConfig");
        sheet.put(props);
        return sheet;
    }

    public final void resultChanged(LookupEvent lookupEvent) {
        boolean isNowSelected = false;
        Lookup.Result selected = (Lookup.Result)lookupEvent.getSource();
        for (Object selectedEntity : selected.allInstances()) {
            if (!((IUnrealBot)this.agent).equals(selectedEntity)) continue;
            isNowSelected = true;
        }
        if (isNowSelected != this.selectedFlag) {
            this.selectedFlag = isNowSelected;
            this.fireDisplayNameChange(null, null);
        }
    }

    public String getHtmlDisplayName() {
        if (this.selectedFlag) {
            return "<b>" + this.getDisplayName() + "</b>";
        }
        return null;
    }

    public void destroy() throws IOException {
        this.selectedResult.removeLookupListener((LookupListener)this);
        super.destroy();
    }

    public Action getPreferredAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPogamutEnvironments environments = (IPogamutEnvironments)Lookup.getDefault().lookup(IPogamutEnvironments.class);
                if (environments == null) {
                    return;
                }
                environments.getEnvironmentSelection(UnrealAgentNode.this.map).changeSelected(UnrealAgentNode.this.agent);
                Action original = UnrealAgentNode.super.getPreferredAction();
                if (original != null) {
                    original.actionPerformed(e);
                }
            }
        };
    }
}

