/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.pogamutlevelmetadata;

/**
 * Exception thrown when there are multiple candidates for a metadata object
 * to be returned, but only one is expected.
 * @author MaCe
 */
public class NoUniqueMetaDataException extends RuntimeException {
    private Class metadataClass;
    private int numOccurences;

    public NoUniqueMetaDataException(Class metadataClass, int numOccurences) {
        super("No unique metadata of class " + metadataClass.getName() + " found. Expected 1, found " + numOccurences);
        this.metadataClass = metadataClass;
        this.numOccurences = numOccurences;
    }

    public Class getMetadataClass() {
        return metadataClass;
    }

    public int getNumOccurences() {
        return numOccurences;
    }

}
