/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.pogamutlevelmetadata;

import com.thoughtworks.xstream.XStream;
import cz.cuni.amis.pogamut.pogamutlevelmetadata.ILevelMetaDataProvider;
import cz.cuni.amis.pogamut.pogamutlevelmetadata.ILevelMetaDataProviderFactory;
import cz.cuni.amis.pogamut.pogamutlevelmetadata.ListLevelMetaDataProvider;
import cz.cuni.amis.pogamut.pogamutlevelmetadata.MetadataLoadingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class AbstractXStreamMetaDataProviderFactory<ObjectId>
implements ILevelMetaDataProviderFactory<ObjectId, String> {
    XStream xstream = new XStream();

    protected abstract InputStream getInputStreamForLevelName(String var1) throws IOException;

    @Override
    public ILevelMetaDataProvider<ObjectId> getMetadataProvider(String levelIdentification) {
        Object metadata;
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStreamForLevelName(levelIdentification);
            if (inputStream == null) {
                return null;
            }
            metadata = this.xstream.fromXML(inputStream);
            inputStream.close();
        }
        catch (Exception ex) {
            throw new MetadataLoadingException("Could not load metadata for level " + levelIdentification, ex);
        }
        if (!(metadata instanceof List)) {
            throw new MetadataLoadingException("Loaded object is not a list");
        }
        return new ListLevelMetaDataProvider((List)metadata);
    }

    public void aliasType(String name, Class type) {
        this.xstream.aliasType(name, type);
    }

    public void aliasField(String alias, Class type, String fieldName) {
        this.xstream.aliasField(alias, type, fieldName);
    }

    public void aliasAttribute(Class configurableClass, String attributeName, String alias) {
        this.xstream.aliasAttribute(configurableClass, attributeName, alias);
    }

    public void aliasAttribute(String alias, String attributeName) {
        this.xstream.aliasAttribute(alias, attributeName);
    }

    public void alias(String name, Class type, Class defaultImplementation) {
        this.xstream.alias(name, type, defaultImplementation);
    }

    public void alias(String name, Class type) {
        this.xstream.alias(name, type);
    }
}

