package cz.cuni.amis.pogamut.emohawk.bot.impl.test;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotController;
import cz.cuni.amis.utils.flag.FlagInteger;
import cz.cuni.amis.utils.flag.ImmutableFlag;

public class LeakModuleTestBotController extends EmohawkBotController<LeakModuleTestBot> {

	private static FlagInteger instances = new FlagInteger(0);
	
	public static ImmutableFlag<Integer> getInstances() {
		return instances.getImmutable();
	}
	
	@Inject
	public LeakModuleTestBotController() {
		super();
		instances.increment(1);
	}
	
	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		instances.decrement(1);
	}
	
}
