package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PlayAnimation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.HashSet;
import java.util.logging.Logger;

/**
 * Module wrapping animation playing.
 * @author knight
 */
public class Animations extends SensomotoricModule<UT2004Bot> {

    /** Object providing animation character mapping */
    AnimationCharacterMapping animCharMapping;
    /** Current intialized character type */
    CharacterType currentCharacterType = null;
    /** Point to self object - provides us with info about current played animation */
    Self self;

    /**
     * Returns current animation of input player.
     * @param player
     * @return
     */
    public AnimType getPlayerAnimation(Player player) {
        return animCharMapping.getAnimTypeFromString(player.getAnim());
    }

    /**
     * Returns current bot anim thas is currently being played.
     * @return
     */
    public AnimType getCurrentPlayedAnimation() {
        if (self == null) return AnimType.NONE;        
        return animCharMapping.getAnimTypeFromString(self.getAnim());         
    }
    
    /**
     * Returns all available animations for a character.
     * @param charType
     * @return
     */
    public HashSet<AnimType> getAvailableAnimations(CharacterType charType) {
        return animCharMapping.getAvailableAnimations(charType);
    }

    /**
     * Returns all available animations for our character.
     * @param charType
     * @return
     */
    public HashSet<AnimType> getAvailableAnimations() {
        if (currentCharacterType != null)
            return animCharMapping.getAvailableAnimations(currentCharacterType);

        return new HashSet(); //empty hash set if our character not set.
    }
    /**
     * Plays input animation on character in loop when bLoop set to true.
     * 
     * Note that movement animations always override animation played this way!
     * 
     * @param animation
     * @param bLoop
     */
    public void playAnimation(AnimType animation, boolean bLoop) {
        if (!animCharMapping.hasAnim(animation, currentCharacterType)) {
            String outString = "Character " + currentCharacterType + " does not own " + animation.getUnrealID() + " animation.";
            this.getLog().warning(outString);
        }
        act.act(new PlayAnimation(animation.getUnrealID(), bLoop));
    }

    /**
     * Plays input animation on character once! Note that movement animations always override
     * animation played this way!
     * @param animation
     */
    public void playAnimation(AnimType animation) {
        if (!animCharMapping.hasAnim(animation, currentCharacterType)) {
            String outString = "Character " + currentCharacterType + " does not own " + animation.getUnrealID() + " animation.";
            this.getLog().warning(outString);
        }
        act.act(new PlayAnimation(animation.getUnrealID(), Boolean.FALSE));
    }
    
    /**
     * Stops animation and replaces it with "standard" one.
     */
    public void stopAnimation() {
    	// TODO
    }

    /**
     * Returns current character type. Null if not recognized or not set!!
     * @return
     */
    public CharacterType getCurrentCharacter() {
        return currentCharacterType;
    }

    /**
     * Listener for Initialize command - we determine here the type of our character
     * for playing animation purposes.
     */
    ICommandListener<Initialize> initCommandListener = new ICommandListener<Initialize>() {
        @Override
        public void notify(Initialize event) {
            if (event.getClassName() != null && !event.getClassName().isEmpty())
                for (CharacterType charType : CharacterType.values()) {
                    if (charType.getUE2Class().contains(event.getClassName()) || charType.getUDKClass().contains(event.getClassName())) {
                        currentCharacterType = charType;
                    }
                }
            //TODO - unhook the listener - not needed anymore - only one init per agent. ?            
        }
    };

    /**
     * Listener for Self object - stores Self object into our link.
     */
    IWorldObjectListener<Self> storeSelfListener = new IWorldObjectListener<Self>() {
        @Override
        public void notify(IWorldObjectEvent<Self> event) {
            if (self == null) {
                self = event.getObject();
                worldView.removeObjectListener(Self.class, this);
                storeSelfListener = null;
            }
        }
    };

    public Animations(UT2004Bot agent, Logger log) {
        super(agent, log);
        //init mapping
        animCharMapping = new AnimationCharacterMapping();
        //init listeners
        act.addCommandListener(Initialize.class, initCommandListener);
        worldView.addObjectListener(Self.class, storeSelfListener);
    }

    public Animations(UT2004Bot agent) {
        super(agent);
        //init mapping
        animCharMapping = new AnimationCharacterMapping();
        //init listeners
        act.addCommandListener(Initialize.class, initCommandListener);
        worldView.addObjectListener(Self.class, storeSelfListener);
    }

}
