package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;


/** Broccoli slices
 */
public class BroccoliSliceReplica extends AbstractVegetableSliceReplica implements IBroccoliSlice {
	
	public static final float BROTH_STRENGTH_POTENTIAL = 0.05f; // in strength per volume*magnitude*time
	
	@Override
	public String getDisplayName() {
		return "Broccoli slice";
	}
	
	@Override
	protected void initializeParameters()
	{
		ingredientComponent.initializeBoilingBehavior(
			BroccoliReplica.COOKING_BASE_TEMPERATURE,
			BroccoliReplica.COOKING_STANDARD_TEMPERATURE,
			BroccoliReplica.BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			BroccoliReplica.COOKING_BASE_TEMPERATURE,
			BroccoliReplica.COOKING_STANDARD_TEMPERATURE,
			BroccoliReplica.CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			BroccoliReplica.CHARREDNESS_RESISTANCE,
			BroccoliReplica.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			BroccoliReplica.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = BroccoliReplica.VOLUME_PER_WHOLE/BroccoliReplica.SLICES_PER_WHOLE;
	}
}