package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.action;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IPawn;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.IChoppableItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ChoppingBoardReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IChoppingBoard;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IKitchenKnife;

/** Action that chops a choppable item on chopping board
 */
public class ChopActionReplica extends AbstractActionReplica {
	
	public static final int ERROR_TARGET_INVALID = 10;
	public static final int ERROR_PERFORMER_NOT_PAWN = 11;
	public static final int ERROR_REQUIRES_KNIFE = 12;
	public static final int ERROR_PAWN_BUSY = 13;
	public static final int ERROR_OUT_OF_RANGE = 14;
	public static final int ERROR_BOARD_BUSY = 15;
	public static final int ERROR_NOTHING_TO_CHOP = 16;
	
	public static final float DEFAULT_RANGE = 200.0f;
	
	public static final String RANGE_ATTR = "range";
		
	/** See EhIAction
	 */
	public String getActionName()
	{
		return "Chop";
	}
	
	/** Get range
	 */
	public float getRange()
	{
		return attributes.floats().get( RANGE_ATTR );
	}
	
	/** Tell if chopper can reach the chopping board 
	 */
	public boolean canReach( IPawn chopper, IChoppingBoard board, double rangeMultiplier )
	{
		return (
			EssenceDistanceTools.computeDistanceOfEssences( chopper, board )
			<=
			getRange()*rangeMultiplier
		);
	}
	
	/** Find choppable item in list
	 */
	public IChoppableItem findChoppableItem( Collection<? extends IItem> list )
	{
		for ( IItem item : list ) {
			if ( item instanceof IChoppableItem ) {
				return (IChoppableItem) item;
			}
		}
		return null;
	}
	
	/** Find kitchen knife in list
	 */
	public IKitchenKnife findKitchenKnife( Collection<? extends IItem> list ) {
		for ( IItem item : list ) {
			if ( item instanceof IKitchenKnife ) {
				return (IKitchenKnife) item;
			}
		}
		return null;
	}
	
	/** Request
	 * 
	 * Client-side only.
	 * 
	 * @param performer action performer
	 * @param board board to chop on, must contain choppable item
	 * @param resultHandler result handler
	 */
	public void request( PawnReplica performer, ChoppingBoardReplica board, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, board );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}