package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.process;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.ds.FoggyRefMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.process.AbstractProcessMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.ChoppingBoardMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.process.ChopProcessReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.process.IChopProcess;

public class ChopProcessMemorization
	extends AbstractProcessMemorization<ChopProcessReplica>
	implements IChopProcess {

	protected FoggyRefMemorization<ChoppingBoardMemorization> board;
	
	public ChopProcessMemorization(
		final ChopProcessReplica object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super(object, observationMemory);
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					if ( !object.isBoardHidden() ) {
						board = new FoggyRefMemorization<ChoppingBoardMemorization>( 
							false, 
							(ChoppingBoardMemorization) observationMemory.getMemorization( object.getBoard() ) 
						);
					} else {
						board = new FoggyRefMemorization<ChoppingBoardMemorization>( true, null );
					}
					
				}
			}
		);			
	}

	@Override
	public ChoppingBoardMemorization getBoard() {
		return board.get();
	}
	
	@Override
	public boolean isBoardHidden() {
		return board.isHidden();
	}
}
