package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.AbstractContainerItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.PawnMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ChoppingBoardReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IChoppingBoard;

public class ChoppingBoardMemorization
	extends AbstractContainerItemMemorization<ChoppingBoardReplica> 
	implements IChoppingBoard {

	protected PawnMemorization<?> chopper;
	
	public ChoppingBoardMemorization(
		final ChoppingBoardReplica object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory, deferredConstructorChainer );
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					PawnMemorization<?> tmp = (PawnMemorization<?>) observationMemory.getMemorization( object.getChopper() );
					chopper = tmp;
				}
			}
		);
	}

	@Override
	public String getDisplayName() {
		return ChoppingBoardReplica.DISPLAY_NAME;
	}

	@Override
	public boolean canStore(IItem item) {
		return ChoppingBoardReplica.canStore( this, item );
	}


	@Override
	public PawnMemorization<?> getChopper() {
		return chopper;
	}	
}
