package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.AbstractEssenceMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IContainerMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.StovePlateReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookware;

public class StovePlateMemorization 
	extends AbstractEssenceMemorization<StovePlateReplica>
	implements IStovePlate, IContainerMemorization<StovePlateReplica> {

	protected float temperature;
	protected StoveMemorization stove;
	protected List<IItemMemorization<IItemReplica>> inventory;
	
	public StovePlateMemorization( 
		final StovePlateReplica object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory );
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					temperature = object.getTemperature();
					if ( object.getStove() != null ) {
						stove = (StoveMemorization) observationMemory.getMemorization( object.getStove() );
					} else {
						stove = null;
					}
					inventory = new LinkedList<IItemMemorization<IItemReplica>>();
					for ( IItemReplica item : object.readInventory() ) {
						inventory.add( (IItemMemorization<IItemReplica>) observationMemory.getMemorization( item ) );
					}
				}
			}
		);
	}

	@Override
	public float getTemperature() {
		return temperature;
	}

	@Override
	public boolean canStore(IItem item) {
		return item instanceof ICookware && readInventory().isEmpty();
	}

	@Override
	public boolean canRelease(IItem item) {
		return true;
	}
	
	@Override
	public StoveMemorization getStove() {
		return stove;
	}

	@Override
	public Collection<? extends IItemMemorization<IItemReplica>> readInventory() {
		return inventory;
	}
}
