package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.AbstractEssenceMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStove;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.StoveReplica;

/** Stove memorization
 * 
 * @author Paletz
 */
public class StoveMemorization
	extends AbstractEssenceMemorization<StoveReplica>
	implements IStove {

	protected int powerLevels[] = new int[StoveReplica.PLATE_COUNT];
	protected StovePlateMemorization plates[] = new StovePlateMemorization[StoveReplica.PLATE_COUNT];
	
	public StoveMemorization(
		final StoveReplica stove,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer 
	) {
		super( stove, observationMemory );
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					for ( int i=0; i<StoveReplica.PLATE_COUNT; ++i ) {
						powerLevels[i] = stove.getPower( i );
						plates[i] = (StovePlateMemorization) observationMemory.getMemorization( stove.getPlate(i) );
					}
				}
			}
		);
	}
	
	@Override
	public int getPower( int index ) {
		return powerLevels[index];
	}
	
	@Override
	public StovePlateMemorization getPlate(int index) {
		return plates[index];
	}
	
}
