package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;

/** Potato
 */
public class PotatoReplication extends AbstractVegetableReplication implements IPotato {
	
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.0025f; 
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.125f; 
	public static final float CHARREDNESS_RESISTANCE = 0.025f; 
	public static final float CHARREDNESS_RESISTANCE_STIRRING_BONUS = 0.05f; 
	public static final float MAX_BUFFERED_CHARREDNESS = 0.5f; 
	public static final float BROTH_STRENGTH_POTENTIAL = 0.0f; 
	public static final float VOLUME_PER_WHOLE = 0.050f; 
	public static final float SLICES_PER_SECOND = 1.0f; 
	public static final int SLICES_PER_WHOLE = 5; 
	
	@Override
	public boolean isPieceItem( IItem item ) {
		return item instanceof IPotatoSlice;
	}
	
	@Override
	public String getDisplayName() {
		return "Potato";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			COOKING_BASE_TEMPERATURE,
			COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			COOKING_BASE_TEMPERATURE,
			COOKING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CHARREDNESS_RESISTANCE,
			CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerWhole = VOLUME_PER_WHOLE;
		slicesPerSecond = SLICES_PER_SECOND;
		slicesPerWhole = SLICES_PER_WHOLE;
	}
}