package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.AbstractContainerItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient.IIngredientMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.FoodTools;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.DishwarePlateReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IDishwarePlate;

/** Dishware plate memorization
 * 
 * @author Paletz
 */
public class DishwarePlateMemorization
	extends AbstractContainerItemMemorization<DishwarePlateReplication> 
	implements IDishwarePlate {
	
	public DishwarePlateMemorization(
		DishwarePlateReplication object,
		ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory, deferredConstructorChainer );
	}

	@Override
	public String getDisplayName() {
		return DishwarePlateReplication.DISPLAY_NAME;
	}

	@Override
	public Collection<? extends IIngredientMemorization<?>> readIngredients() {
		return FoodTools.readIngredients( readInventory() );
	}
	
	@Override
	public boolean canStore( IItem item ) {
		return FoodTools.canStoreFood( readIngredients(), item, DishwarePlateReplication.FOOD_CAPACITY );
	}
	
	@Override
	public boolean canRelease( IItem item ) {
		return false;
	}
}