package cz.cuni.amis.pogamut.emohawk.factory.guice.remoteagent;

import com.google.inject.AbstractModule;

import cz.cuni.amis.pogamut.emohawk.communication.EmohawkYylex;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.parser.IUT2004Yylex;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;

/** Emohawk bot module
 * 
 * 
 * @author Paletz
 */
public class EmohawkBotModule<PARAMS extends UT2004BotParameters> extends UT2004BotModule<PARAMS> {

	public EmohawkBotModule( Class<? extends IUT2004BotController<?> > botControllerClass ) {
		super(botControllerClass);
	}
	
	@Override
	protected void configureModules() {
		super.configureModules();
		// override yylex to emohawk yylex
		addModule(
			new AbstractModule() {
				@Override
				protected void configure() {
					bind(IUT2004Yylex.class).to(EmohawkYylex.class);					
				}
			}
		);
	}
}
