package cz.cuni.amis.pogamut.emohawk.agent.module.stream;

import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;

/** Input stream interface
 * 
 * Input stream of unreal primitives.
 */
public interface IInputStream {

	/** Tell type of next primitive
	 * 
	 * @return type of next primitive or PAYLOAD_TYPE_EOF if there is none
	 */
	PayloadType tellNext();
	
	/** Read integer primitive
	 * 
	 * Results in error if next primitive is not an integer. See also tellNext().
	 * @return integer
	 */
	int readInt();
	
	/** Read float primitive
	 * 
	 * Results in error if next primitive is not an float. See also tellNext().
	 * @return float
	 */
	float readFloat();
	
	/** Read bool primitive
	 * 
	 * Results in error if next primitive is not a bool. See also tellNext().
	 * @return bool
	 */
	boolean readBool();
	
	/** Read string primitive
	 * 
	 * Results in error if next primitive is not a string. See also tellNext().
	 * @return string
	 */
	String readString();
}