package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object;

/** Replication ID
 * 
 * Immutable.
 * 
 * @author Paletz
 */
public class ReplicationId {
	protected int index;
	protected int generationNumber;
	
	public ReplicationId( int index, int generationNumber ) {
		this.index = index;
		this.generationNumber = generationNumber;
	}

	/** Get the index
	 * 
	 * @return the index
	 */
	public int getIndex() {
		return index;
	}

	/** Get the generationNumber
	 * @return the generationNumber
	 */
	public int getGenerationNumber() {
		return generationNumber;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		return (prime + generationNumber) * prime + index;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object other) {
		
		if ( ! ( other instanceof ReplicationId ) ) {
			return false;
		}
		
		ReplicationId otherId = (ReplicationId) other;
		return (
			generationNumber == otherId.generationNumber
			&&
			index == otherId.index 
		);
	}
	
	public String toGbMessageParameter( String parameterName )
	{
		StringBuilder builder = new StringBuilder();
		builder.append( "{"+parameterName+"Index "+index+"}" );
		builder.append( " " );
		builder.append( "{"+parameterName+"GenNum "+generationNumber+"}" );
		return builder.toString();
	}
}
