package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Object replicated from Unreal script
 */
public interface IObjectReplica {

	/** Get replication id
	 * 
	 * @return replication id assigned by the replication server
	 */
	ReplicationId getReplicationId();

	/** Get replication index
	 * 
	 * @return replication index assigned by the replication server
	 */
	int getReplicationIndex();
	
	/** Get replication generation number
	 * 
	 * @return replication generation number assigned by the replication server
	 */
	int getReplicationGenerationNumber();
	
	/** Receive object state from server
	 *  
	 * @param stream input stream, contains data sent by send(), all such data must be extracted, no less, no more
	 */
	void receive( IInputObjectStream stream );
	
	/** Initilize replicated image
	 *  
	 *  Called by object replication client to initialize replication state of image object.
	 */
	void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId );
	
	/** Tell if object is an active image
	 *
	 * @return true if object is active image, false if object has been torn-off or never was image
	 */
	boolean isLive();
	
	/** Finalize replication
	 * 
	 * Called by object replication client or server to finalize replication state of the object.
	 */
	void finalizeReplication();
}
