package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object;



/** Abstract implementation of IObjectReplica
 * 
 * Stores passed type paremeters into array.
 */
public abstract class AbstractGenericObjectReplica extends AbstractObjectReplica implements IGenericObjectReplica {
	
	/** Array with type parameters
	 */
	protected SpecializedClass<?> typeParameters[];
	
	/** Constructor
	 * 
	 * @param typeParameterCount type parameter count
	 */
	public AbstractGenericObjectReplica( int typeParameterCount ) {
		typeParameters = new SpecializedClass[typeParameterCount];
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IGenericReplicableObject#setTypeParameter(int, cz.cuni.amis.pogamut.emohawk.agent.module.replication.SpecializedClass)
	 */
	@Override
	public void setTypeParameter(int index, SpecializedClass<?> value) {
		typeParameters[index] = value;
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IGenericReplicableObject#setTypeParameter(int, cz.cuni.amis.pogamut.emohawk.agent.module.replication.SpecializedClass)
	 */
	@Override
	public SpecializedClass<?> getTypeParameter(int index) {
		return typeParameters[index];
	}

	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IGenericReplicableObject#setTypeParameter(int, cz.cuni.amis.pogamut.emohawk.agent.module.replication.SpecializedClass)
	 */
	@Override
	public int getTypeParameterCount() {
		return typeParameters.length;
	}
}
