package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;

/** Primitive Unreal type tools
 * 
 * Supports object reference too.
 * @author Paletz
 */
public class PrimitiveTools {
	
	/** Read primitive from stream
	 * 
	 * Picks the right method to read the primitive.
	 * 
	 * @param primitiveClass class of primitive to read
	 * @param inputStream input stream
	 * @return read primitive value
	 */
	public static Object readPrimitive( Class<?> primitiveClass, IInputObjectStream inputStream ) {
		if ( primitiveClass == Integer.class ) {
			return new Integer( inputStream.readInt() );
		} else if ( primitiveClass == Boolean.class ) {
			return new Boolean( inputStream.readBool() );
		} else if ( primitiveClass == String.class ) {
			return inputStream.readString();
		} else if ( primitiveClass == Float.class ) {
			return new Float( inputStream.readFloat() );
		} else if ( IObjectReplica.class.isAssignableFrom( primitiveClass ) ) {
			return inputStream.readObjectRef();
		} else {
			throw new AssertionError( "Unexpected primitive class "+primitiveClass );
		}
	}
	
	/** Write primitive type to a stream
	 * 
	 * Picks the right method to write the primitive.
	 * 
	 * @param primitive value to write
	 * @param outputStream output stream
	 */
	public static void writePrimitive( Object primitive, IOutputStream outputStream ) {
		if ( primitive instanceof Integer ) {
			outputStream.writeInt( (Integer) primitive );
		} else if ( primitive instanceof Boolean ) {
			outputStream.writeBool( (Boolean) primitive );
		} else if ( primitive instanceof String ) {
			outputStream.writeString( (String) primitive );
		} else if ( primitive instanceof Float ) {
			outputStream.writeFloat( (Float) primitive );
		} else if ( primitive instanceof IObjectReplica ) {
			throw new AssertionError( "Object references not supported." );
		} else {
			throw new AssertionError( "Unexpected primitive class "+primitive.getClass() );
		}
	}
}
