package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;

/** List attribute view
 *  
 * Filters attribute not matching given list type.
 */
public class ListAttributeView<T> implements IListAttributeView<T> {
	
	protected AttributeRawView<ListAttributeReplica<T>,Iterable<T>> rawView;
	protected SpecializedClass<T> primitiveClass;
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ListAttributeView( 
		SpecializedClass<T> primitiveClass, 
		ListMapReplica<IAttributeReplica> attributes,
		AttributeUpstream upstream 
	) {
		this.primitiveClass = primitiveClass;
		rawView = new AttributeRawView<ListAttributeReplica<T>,Iterable<T>>( 
			attributes,
			upstream,
			new SpecializedClass<ListAttributeReplica<T>>( 
				(Class) ListAttributeReplica.class, // java is really dumb here
				Arrays.asList( new SpecializedClass<?>[] { primitiveClass } )
			)
		);
	}
	
	@Override
	public Collection<T> read( String attributeName ) {
		ListAttributeReplica<T> attribute = rawView.getAttributeRecord( attributeName );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		SinglyLinkedListReplica<T> retval = (SinglyLinkedListReplica<T>) attribute.getValue();
		assert( primitiveClass.equals( retval.getValueClass() ) );
		return retval;
	}

	@Override
	public void send( String attributeName, Iterable<T> value ) {
		rawView.send( attributeName, value );
	}

	@Override
	public boolean exists( String attributeName, AttributeAccess access ) {
		return rawView.exists( attributeName, access );
	}
	
	@Override
	public Iterator<ListMapEntryReplica<ListAttributeReplica<T>>> iterator() {
		return rawView.iterator();
	}
}
