package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyref;

import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;

/** Primitive attribute view
 * 
 * Filters attribute not matching given list type.
 */
public class FoggyRefAttributeView implements IFoggyRefAttributeView {

	protected AttributeRawView<FoggyRefAttributeReplica,IObjectReplica> rawView;
	
	public FoggyRefAttributeView( ListMapReplica<IAttributeReplica> attributes, AttributeUpstream upstream ) {
		rawView = new AttributeRawView<FoggyRefAttributeReplica,IObjectReplica>( 
			attributes,
			upstream,
			SpecializedClass.fromPlain( FoggyRefAttributeReplica.class )
		);
	}
	
	@Override
	public IObjectReplica get( String attributeName ) {
		FoggyRefAttributeReplica attribute = rawView.getAttributeRecord( attributeName );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		return attribute.getValue().get();	
	}
	
	@Override
	public boolean isHidden( String attributeName ) {
		FoggyRefAttributeReplica attribute = rawView.getAttributeRecord( attributeName );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		return attribute.getValue().isHidden();	
	}
	
	@Override
	public void set( String attributeName, IObjectReplica value ) {
		rawView.send( attributeName, value );
	}
	
	@Override
	public boolean exists( String attributeName, AttributeAccess access ) {
		return rawView.exists( attributeName, access );
	}
	
	@Override
	public Iterator<ListMapEntryReplica<FoggyRefAttributeReplica>> iterator() {
		return rawView.iterator();
	}
}