package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IPerformerReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.AbstractEssenceReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream;
import cz.cuni.amis.pogamut.ut2004.communication.messages.IPerson;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

/** Player pawn
 * 
 * @author Paletz
 */
public class PawnReplica extends AbstractEssenceReplica implements IPawn, IPerformerReplica {
	
	protected ActionUpstream actionUpstream;
	
	@Override
	public IPerson getActor() {
		if ( actorId.length() > 0 ) {
			IPerson retval = world.get( WorldObjectId.get( "SELF_"+actorId ), Self.class );
			if ( retval == null ) {
				retval = world.get( WorldObjectId.get( actorId ), Player.class );
			}
			return retval;
		} else {
			return null;
		}
	}
	
	@Override
	public void requestAction( IActionReplica action, IActionResultHandler resultHandler, IInputStream serializedCustomArguments ) {
		actionUpstream.requestAction( this, action, resultHandler, serializedCustomArguments );
	}
	
	@Override
	public void receive( IInputObjectStream stream) {
		super.receive( stream );
		actorId = stream.readString();
		if ( !actorId.isEmpty() ) {
			objectReplicationClient.getModule( EssenceMap.class ).associatePawn( actorId, this );
		} else {
			System.out.println( "Actor ID is empty." );
		}
		
		actionUpstream = objectReplicationClient.getModule( ActionUpstream.class );
	}
}
