package cz.cuni.amis.pogamut.emohawk.agent.module.essence;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.IEssence;

/** Essence distance tools
 *
 * @author Paletz
 */
public class EssenceDistanceTools {
	
	/** Compute distance between two essence
	 *
	 * @param aEssence essence of actor A
	 * @param bEssence essence of actor B
	 * @return distance or positive infinity if either essence is ethereal
	 */
	public static double computeDistanceOfEssences( IEssence aEssence, IEssence bEssence ) {
		Location bLocation = bEssence.getActorLocation();
		if ( bLocation != null ) {
			return computeDistanceOfEssenceToLocation( aEssence, bLocation );
		} else {
			return Double.POSITIVE_INFINITY;		
		}
	}

	/** Compute distance between essence and location
	 * 
	 * @param aEssence essence of actor A
	 * @param bLocation location of actor B
	 * @return distance or `c(EhUnrealScriptTools).MAX_FLOAT if the essence is ethereal
	 */
	public static double computeDistanceOfEssenceToLocation( IEssence aEssence, Location bLocation ) {
		Location aLocation = aEssence.getActorLocation();
		if ( aLocation != null ) { 
			return bLocation.getDistance( aLocation ); 
		} else {
			return Double.POSITIVE_INFINITY;
		}
	}
}
