/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.SemifinishedMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.PawnMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.IEssenceMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.IEssenceReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IUniqueGameObject;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Trace;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TraceResponse;
import cz.cuni.amis.pogamut.ut2004.utils.UnrealUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ObservationMemory
implements IObservationMemory {
    public static final double TRACE_EXPOSING_RADIUS = 1.0;
    protected IAct act;
    protected IVisionWorldView worldView;
    protected IEssenceMap essenceMap;
    protected AgentInfo agentInfo;
    protected Map<IEssenceMemorization<?>, SightingInfo> sightings;
    protected Map<IObjectReplica, IObjectMemorization<?>> memorizationCache;
    protected Map<IObjectMemorization<?>, IObjectReplica> reverseMemorizationCache;
    protected int tracesPerFrame;
    protected double currentEpochTime;
    protected IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            ObservationMemory.this.observe();
        }
    };
    protected IWorldEventListener<TraceResponse> traceResponseListener = new IWorldEventListener<TraceResponse>(){

        public void notify(TraceResponse event) {
            if (!event.isTraceActors()) {
                return;
            }
            if (event.isResult()) {
                return;
            }
            Location traceEnd = event.getTo();
            if (!ObservationMemory.this.isWithinFov(traceEnd)) {
                return;
            }
            Iterator<IEssenceMemorization<?>> sightingIterator = ObservationMemory.this.sightings.keySet().iterator();
            while (sightingIterator.hasNext()) {
                IEssenceMemorization<?> sighting = sightingIterator.next();
                if (sighting.getMemorizationEpochTime() == ObservationMemory.this.currentEpochTime || !(sighting.getActorLocation().getDistance(traceEnd) < 1.0)) continue;
                sightingIterator.remove();
            }
        }
    };

    public ObservationMemory(IAct act, IVisionWorldView worldView, IEssenceMap essenceMap, AgentInfo agentInfo) {
        this.act = act;
        this.worldView = worldView;
        this.essenceMap = essenceMap;
        this.agentInfo = agentInfo;
        this.sightings = new HashMap();
        worldView.addEventListener(EndMessage.class, this.endMessageListener);
        worldView.addEventListener(TraceResponse.class, this.traceResponseListener);
        this.tracesPerFrame = 1;
        this.memorizationCache = new HashMap();
        this.reverseMemorizationCache = new HashMap();
        this.currentEpochTime = 0.0;
    }

    @Override
    public List<? extends IEssenceMemorization<?>> getAll() {
        ArrayList<IEssenceMemorization> retval = new ArrayList<IEssenceMemorization>();
        for (IEssenceMemorization memorization : this.getAllByMemorization(IEssenceMemorization.class)) {
            retval.add(memorization);
        }
        return retval;
    }

    @Override
    public <TMemorization extends IEssenceMemorization<?>> List<TMemorization> getAllByMemorization(Class<? extends TMemorization> memorizationClass) {
        ArrayList retval = new ArrayList();
        for (IEssenceMemorization<?> memorization : this.sightings.keySet()) {
            if (!memorizationClass.isInstance(memorization)) continue;
            IEssenceMemorization<?> added = memorization;
            retval.add(added);
        }
        return retval;
    }

    @Override
    public void setImportance(IEssenceMemorization<?> memorizedEssence, double importance) {
        assert (this.sightings.containsKey(memorizedEssence));
        assert (importance >= 0.0);
        this.sightings.get(memorizedEssence).importance = importance;
    }

    @Override
    public <TReplica extends IObjectReplica> IObjectMemorization<TReplica> getMemorization(TReplica object) {
        if (object == null) {
            return null;
        }
        assert (object.isLive());
        IObjectMemorization<?> memorization = this.memorizationCache.get(object);
        if (memorization == null) {
            SemifinishedMemorization semifinishedMemorization = this.makeMemorization(object);
            memorization = semifinishedMemorization.memorization;
            this.memorizationCache.put(object, memorization);
            this.reverseMemorizationCache.put(memorization, object);
            semifinishedMemorization.finishConstruction();
            if (memorization instanceof IUniqueGameObject) {
                int newMemorizationGameObjectId = ((IUniqueGameObject)((Object)memorization)).getGameObjectId();
                IEssenceMemorization<?> contradictedSighting = null;
                for (IEssenceMemorization<?> sighting : this.sightings.keySet()) {
                    if (sighting.getGameObjectId() != newMemorizationGameObjectId) continue;
                    contradictedSighting = sighting;
                }
                if (contradictedSighting != null) {
                    this.contradict(contradictedSighting);
                }
            }
        }
        IObjectMemorization<?> retval = memorization;
        return retval;
    }

    @Override
    public void contradict(IEssenceMemorization<?> contradictedSighting) {
        this.sightings.remove(contradictedSighting);
    }

    public <MemorizedClass extends IObjectReplica> MemorizedClass getPreimage(IObjectMemorization<MemorizedClass> freshMemorization) {
        IObjectReplica retval = this.reverseMemorizationCache.get(freshMemorization);
        return (MemorizedClass)retval;
    }

    @Override
    public double getEpochTime() {
        return this.currentEpochTime;
    }

    protected SemifinishedMemorization makeMemorization(IObjectReplica object) {
        SemifinishedMemorization retval = new SemifinishedMemorization();
        if (object instanceof PawnReplica) {
            retval.memorization = new PawnMemorization<PawnReplica>((PawnReplica)object, this);
            return retval;
        }
        throw new AssertionError((Object)"Unexpected object");
    }

    protected void observe() {
        IEssenceMemorization<?> tracedSighting;
        this.memorizationCache.clear();
        this.reverseMemorizationCache.clear();
        assert (this.currentEpochTime < this.agentInfo.getTime());
        this.currentEpochTime = this.agentInfo.getTime();
        for (Map.Entry<IWorldObject, IEssenceReplica> entry : this.essenceMap.getAllVisible(IEssenceReplica.class).entrySet()) {
            IWorldObject seenWorldObject = entry.getKey();
            if (!(seenWorldObject instanceof ILocated)) continue;
            this.sightings.put((IEssenceMemorization)this.getMemorization((IObjectReplica)entry.getValue()), new SightingInfo(this.agentInfo.getTime()));
        }
        for (int i = 0; i < this.tracesPerFrame && (tracedSighting = this.findMemoryRecordWithTopTracePriority()) != null; ++i) {
            this.act.act((CommandMessage)new Trace("EmoMmr" + i, null, tracedSighting.getActorLocation(), Boolean.valueOf(true)));
            this.sightings.get(tracedSighting).lastTraceAttemptTime = this.agentInfo.getTime();
        }
    }

    protected IEssenceMemorization<?> findMemoryRecordWithTopTracePriority() {
        IEssenceMemorization<?> sightingWithTopTracePriority = null;
        double topTracePriority = 0.0;
        for (IEssenceMemorization<?> sighting : this.sightings.keySet()) {
            double tracePriority = this.computeTracePriority(sighting);
            if (!(topTracePriority < tracePriority)) continue;
            sightingWithTopTracePriority = sighting;
            topTracePriority = tracePriority;
        }
        return sightingWithTopTracePriority;
    }

    protected double computeTracePriority(IEssenceMemorization<?> sighting) {
        if (!this.isWithinFov(sighting.getActorLocation())) {
            return 0.0;
        }
        double timeSinceSeen = this.currentEpochTime - sighting.getMemorizationEpochTime();
        double timeSinceTraceAttempt = this.currentEpochTime - this.sightings.get(sighting).lastTraceAttemptTime;
        double importance = this.sightings.get(sighting).importance;
        double distance = Math.max(50.0, this.agentInfo.getDistance((ILocated)sighting.getActorLocation()));
        return Math.max(0.0, importance * timeSinceSeen * timeSinceTraceAttempt / distance);
    }

    protected boolean isWithinFov(Location location) {
        Location locationOffset = location.getLocation().sub(this.agentInfo.getLocation()).getNormalized();
        double azimuth = UnrealUtils.unrealDegreeToRad((double)this.agentInfo.getRotation().getYaw());
        double elevation = UnrealUtils.unrealDegreeToRad((double)this.agentInfo.getRotation().getPitch());
        Matrix3d matrix = new Matrix3d();
        matrix.rotY(elevation);
        matrix.rotZ(azimuth);
        Vector3d vector = new Vector3d(1.0, 0.0, 0.0);
        matrix.transform((Tuple3d)vector);
        Location focusOffset = new Location((Tuple3d)vector);
        double angleBetweenFocusAndLocation = Math.acos(locationOffset.dot(focusOffset));
        return angleBetweenFocusAndLocation < 1.0471975511965976;
    }

    protected class SightingInfo {
        public double importance = 1.0;
        public double lastTraceAttemptTime;

        public SightingInfo(double lastTraceAttemptTime) {
            this.lastTraceAttemptTime = lastTraceAttemptTime;
        }
    }
}

