package cz.cuni.amis.pogamut.emohawk.communication.action;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.MajorActionResult;

/** Interaction error
 * 
 * @author Paletz
 */
public class ActionResult extends InfoMessage implements IWorldEvent, IWorldChangeEvent {
	
	protected long simTime;
	protected MajorActionResult major;
	protected int minor;
	protected String message;
	protected int userRequestId;
	
	public ActionResult() {
		simTime = 0;
		minor = 0;
		userRequestId = -1;
	}	
	
	/** Get simTime
	 * 
	 * @return simTime
	 */
	public long getSimTime()
	{
		return simTime;
	}
	
	/**Get the major result
	 * 
	 * @return the major result
	 */
	public MajorActionResult getMajor() {
		return major;
	}
	
	/** Get the minor result
	 * 
	 * @return the minor result
	 */
	public int getMinor() {
		return minor;
	}
	
	/** Get the error message
	 * 
	 * @return the error message 
	 */
	public String getMessage() {
		return message;
	}
	
	/** Get the user request ID
	 * 
	 * @return the user request ID
	 */
	public int getUserRequestId() {
		return userRequestId;
	}
	
	/** Initialization from yylex
	 */
	protected void setSimTime( long value ) {
		simTime = value;
	}
	
	/** Initialization from yylex
	 */
	public void setMajor(MajorActionResult value) {
		this.major = value;
	}
	
	/** Initialization from yylex
	 */
	public void setMinor(int minor) {
		this.minor = minor;
	}
	
	/** Initialization from yylex
	 */
	public void setMessage( String value ) {
		this.message = value;
	}

	/** Initialization from yylex
	 */
	public void setUserRequestId( int value ) {
		this.userRequestId = value;
	}

}
