package cz.cuni.amis.pogamut.emohawk.agent.module.stream;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;

/** Object stream buffer
 * 
 * Adds object buffering.
 * 
 * @author Paletz
 */
public class ObjectStreamBuffer extends StreamBuffer implements IInputObjectStream {

	/** Write object reference
	 */
	public void writeObjectRef( IObjectReplica value ) {
		data.add( value );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream#readObjectRef()
	 */
	@Override
	public IObjectReplica readObjectRef() {
		return (IObjectReplica) data.pop();
	}
	
	@Override
	protected PayloadType tellType( Object payload ) {
		if ( payload instanceof IObjectReplica ) {
			return PayloadType.PAYLOAD_TYPE_OBJECT_REF;
		} else {
			return super.tellType( payload );
		}
	}
}
