package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyreflist;

import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;

/** Foggy reference list attribute view
 *  
 * Filters attribute not matching given list type.
 */
public class FoggyRefListAttributeView implements IFoggyRefListAttributeView {
	
	protected AttributeRawView<FoggyRefListAttributeReplica, Iterable<IObjectReplica>> rawView;
		
	public FoggyRefListAttributeView( 
		ListMapReplica<IAttributeReplica> attributes,
		AttributeUpstream upstream 
	) {
		rawView = new AttributeRawView<FoggyRefListAttributeReplica, Iterable<IObjectReplica>>( 
			attributes,
			upstream,
			SpecializedClass.fromPlain( FoggyRefListAttributeReplica.class )
		);
	}
	
	@Override
	public SinglyLinkedListReplica<FoggyRefReplica> read( String attributeName ) {
		FoggyRefListAttributeReplica attribute = rawView.getAttributeRecord( attributeName );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		return attribute.getValue();
	}

	@Override
	public void send( String attributeName, Iterable<IObjectReplica> value ) {
		rawView.send( attributeName, value );
	}

	@Override
	public boolean exists( String attributeName, AttributeAccess access ) {
		return rawView.exists( attributeName, access );
	}
	
	@Override
	public Iterator<ListMapEntryReplica<FoggyRefListAttributeReplica>> iterator() {
		return rawView.iterator();
	}
}
