package cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.AbstractObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.IEssenceReplica;

/** Abstract memorization of an essence
 *  
 * @author Paletz
 */
public abstract class AbstractEssenceMemorization
	<MemorizedClass extends IEssenceReplica> 
	extends AbstractObjectMemorization<MemorizedClass> 
	implements IEssenceMemorization<MemorizedClass> {

	protected Location actorLocation;
	protected WorldObjectId actorId;
	protected int gameObjectId;
	
	public AbstractEssenceMemorization( MemorizedClass object, ObservationMemory observationMemory ) {
		super( object, observationMemory );
		this.actorLocation = object.getActorLocation();
		this.actorId = object.getActorId();
		this.gameObjectId = object.getGameObjectId();
	}

	@Override
	public Location getActorLocation() {
		return actorLocation;
	}

	@Override
	public WorldObjectId getActorId() {
		return actorId;
	}

	@Override
	public int getGameObjectId() {
		return gameObjectId;
	}
}
