package cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory;

import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;

/** Semifinished memorization
 * 
 * In order to break reference cycles memorization constructor must deferr resolving of references.
 * For this purpose a deferred constructor can be added here.
 */
public class SemifinishedMemorization implements IDeferredConstructorChainer {
	public IObjectMemorization<?> memorization;
	protected List<IDeferredConstructor> deferredConstructorChain;
	
	public SemifinishedMemorization() {
		deferredConstructorChain = new LinkedList<IDeferredConstructor>();
	}
	
	/** Add resolver
	 * 
	 * @param resolver
	 */
	public void addDeferredConstructor( IDeferredConstructor deferredConstructor ) {
		deferredConstructorChain.add( deferredConstructor );
	}
	
	public void finishConstruction() {
		for ( IDeferredConstructor deferredConstructor : deferredConstructorChain ) {
			deferredConstructor.construct();
		}
		deferredConstructorChain.clear();
	}
}


