package cz.cuni.amis.pogamut.defcon.utils.tests.qtree;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.JFrame;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;

public class QuadTreeWindow extends JFrame {

	public QuadTreeWindow(QuadTree qTree, List<Location> poly) {
		super("QuadTree");
		setSize(1024, 768);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setVisible(true);

		Container container = getContentPane();

		BorderLayout layout = new BorderLayout();
		container.setLayout(layout);

		QuadTreeVisualizer visualizer = new QuadTreeVisualizer(qTree, poly);

		container.add(visualizer);
		
		visualizer.addMouseListener(new MouseAdapter() {
		    @Override
		    public void mousePressed(MouseEvent e) {
		        dispose();
		    }			
		});
		setContentPane(container);
	}
}
