package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for Fighters.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum FighterState implements IState {

	ATTACK(JBot.STATE_FIGHTERATTACK),	
    IN_QUEUE(JBot.STATE_FIGHTERINQUEUE);
	
	private static Map<Integer, FighterState> states = new HashMap<Integer, FighterState>();
	
	public static FighterState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (FighterState state : FighterState.values()) {
			states.put(state.getStateId(), state);
		}
	}
	
	public final int id;
	
	private FighterState(int id) {
		this.id = id;
	}

	@Override
	public int getStateId() {
		return id;
	}
	
	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}

}
