package cz.cuni.amis.pogamut.defcon.agentmanager;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.impl.AgentParameters;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agentmanager.exception.CantInstantiateAgentException;
import cz.cuni.amis.pogamut.defcon.agentmanager.exception.ModuleForAgentClassNotFoundException;
import cz.cuni.amis.pogamut.defcon.factory.DefConAgentModule;

/**
 * This class is being used to instantiate new agents.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class DefConAgentManager {

	private static final DefConAgentManager instance = new DefConAgentManager();

	public static DefConAgentManager getInstance() {
		return instance;
	}

	private DefConAgentManager() {
	}

	/**
	 * Instantiates a new agent from given module.
	 * 
	 * @param <T>
	 *            Agent's super type (useful for simpler conversions).
	 * @param cls
	 *            Module class.
	 * @return Instantiated agent.
	 * @throws CantInstantiateAgentException
	 *             Instantiation failed.
	 * @throws ModuleForAgentClassNotFoundException
	 *             Module is null?
	 */
	public <T extends DefConAgent<?>> T getAgentInstance(
			Class<? extends DefConAgentModule> cls)
			throws CantInstantiateAgentException,
			ModuleForAgentClassNotFoundException {

		DefConAgentModule module;
		try {
			module = cls.newInstance();
		} catch (InstantiationException e1) {
			throw new CantInstantiateAgentException(e1.getMessage(), this);
		} catch (IllegalAccessException e1) {
			throw new ModuleForAgentClassNotFoundException(e1.getMessage(),
					this);
		}

		try {
			AgentParameters params = new AgentParameters();
			IAgentId id = params.setAgentId(new AgentId("DefConBot"))
					.getAgentId();
			module.newBindings(id);
			GuiceAgentFactory<DefConAgent, AgentParameters> factory =
					new GuiceAgentFactory<DefConAgent, AgentParameters>(module);
			return (T) factory.newAgent(params);
		} catch (Exception e) {
			throw new CantInstantiateAgentException("Instantiation of "
					+ cls.getName() + " agent failed.", e, this);
		}
	}

	/**
	 * Simplified call to getAgentInstance(Class<? extends DefConAgentModule>
	 * cls)
	 * 
	 * @param className
	 *            simple class name
	 * @return instantiated agent
	 * @throws CantInstantiateAgentException
	 *             Instantiation failed.
	 * @throws ModuleForAgentClassNotFoundException
	 *             Module is null?
	 */
	public DefConAgent getAgentInstance(String className)
			throws CantInstantiateAgentException,
			ModuleForAgentClassNotFoundException {
		Class cls;
		try {
			cls = Class.forName(className);
		} catch (ClassNotFoundException e) {
			throw new IllegalArgumentException("Class " + className
					+ " not found.");
		}
		if (!DefConAgent.class.isAssignableFrom(cls)) {
			throw new IllegalArgumentException(className
					+ " is not subclass od AbstractDefConAgent");
		}
		return getAgentInstance(cls);
	}

}
