package cz.cuni.amis.pogamut.defcon.generator;


import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;

/**
 * Provides a fleet composition based on the given fleet type.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class FleetGenerator {

	public enum FleetType {
		SUBS,
		CARRIERS,
		BATTLESHIPS,
		CARRIERS_WITH_SUBS,
		CARRIERS_WITH_BATTLESHIPS,
		BATTLESHIPS_WITH_SUBS,
		MIXED
	}

	public static UnitType[] getNewFleet(FleetType type, GameInfo info) {
		// int creds_left = info.getUnitCredits();
		UnitType[] output = null;
		switch (type) {
			case SUBS:
				output = fillWith(UnitType.SUB, info);
				break;
			case CARRIERS:
				output = fillWith(UnitType.CARRIER, info);
				break;
			case BATTLESHIPS:
				output = fillWith(UnitType.BATTLE_SHIP, info);
				break;
			case CARRIERS_WITH_SUBS:
				output = new UnitType[] {
						UnitType.CARRIER,
						UnitType.CARRIER,
						UnitType.CARRIER,
						UnitType.SUB,
						UnitType.SUB,
						UnitType.SUB };
				break;
			case CARRIERS_WITH_BATTLESHIPS:
				output = new UnitType[] {
						UnitType.BATTLE_SHIP,
						UnitType.BATTLE_SHIP,
						UnitType.BATTLE_SHIP,
						UnitType.CARRIER,
						UnitType.CARRIER,
						UnitType.CARRIER };
				break;
			case BATTLESHIPS_WITH_SUBS:
				output = new UnitType[] {
						UnitType.BATTLE_SHIP,
						UnitType.BATTLE_SHIP,
						UnitType.BATTLE_SHIP,
						UnitType.SUB,
						UnitType.SUB,
						UnitType.SUB };
				break;
			case MIXED:
				output = new UnitType[] {
						UnitType.BATTLE_SHIP,
						UnitType.BATTLE_SHIP,
						UnitType.CARRIER,
						UnitType.CARRIER,
						UnitType.SUB,
						UnitType.SUB };
			default:
				break;
		}

		return output;
	}

	private static UnitType[] fillWith(UnitType type, GameInfo info) {
		int creds_left = info.getUnitCredits();
		int price_for_one = info.getUnitValue(type);

		if (creds_left < price_for_one)
			return null;

		UnitType[] output = new UnitType[6];

		int i = 0;
		for (; i < 6 && creds_left >= price_for_one; ++i) {
			output[i] = type;
			creds_left -= price_for_one;
		}
		for (; i < 6; ++i) {
			output[i] = null;
		}
		return output;
	}
}
